/**
 * @license
 * Copyright 2019 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */const ne=Symbol("Comlink.proxy"),Pe=Symbol("Comlink.endpoint"),xe=Symbol("Comlink.releaseProxy"),$=Symbol("Comlink.finalizer"),Y=Symbol("Comlink.thrown"),ae=e=>typeof e=="object"&&e!==null||typeof e=="function",Ue={canHandle:e=>ae(e)&&e[ne],serialize(e){const{port1:t,port2:r}=new MessageChannel;return j(e,t),[r,[r]]},deserialize(e){return e.start(),Se(e)}},we={canHandle:e=>ae(e)&&Y in e,serialize({value:e}){let t;return e instanceof Error?t={isError:!0,value:{message:e.message,name:e.name,stack:e.stack}}:t={isError:!1,value:e},[t,[]]},deserialize(e){throw e.isError?Object.assign(new Error(e.value.message),e.value):e.value}},ie=new Map([["proxy",Ue],["throw",we]]);function Be(e,t){for(const r of e)if(t===r||r==="*"||r instanceof RegExp&&r.test(t))return!0;return!1}function j(e,t=globalThis,r=["*"]){t.addEventListener("message",function m(s){if(!s||!s.data)return;if(!Be(r,s.origin)){console.warn(`Invalid origin '${s.origin}' for comlink proxy`);return}const{id:u,type:p,path:o}=Object.assign({path:[]},s.data),d=(s.data.argumentList||[]).map(M);let i;try{const f=o.slice(0,-1).reduce((n,l)=>n[l],e),a=o.reduce((n,l)=>n[l],e);switch(p){case"GET":i=a;break;case"SET":f[o.slice(-1)[0]]=M(s.data.value),i=!0;break;case"APPLY":i=a.apply(f,d);break;case"CONSTRUCT":{const n=new a(...d);i=Ae(n)}break;case"ENDPOINT":{const{port1:n,port2:l}=new MessageChannel;j(e,l),i=ve(n,[n])}break;case"RELEASE":i=void 0;break;default:return}}catch(f){i={value:f,[Y]:0}}Promise.resolve(i).catch(f=>({value:f,[Y]:0})).then(f=>{const[a,n]=H(f);t.postMessage(Object.assign(Object.assign({},a),{id:u}),n),p==="RELEASE"&&(t.removeEventListener("message",m),se(t),$ in e&&typeof e[$]=="function"&&e[$]())}).catch(f=>{const[a,n]=H({value:new TypeError("Unserializable return value"),[Y]:0});t.postMessage(Object.assign(Object.assign({},a),{id:u}),n)})}),t.start&&t.start()}function Ee(e){return e.constructor.name==="MessagePort"}function se(e){Ee(e)&&e.close()}function Se(e,t){const r=new Map;return e.addEventListener("message",function(s){const{data:u}=s;if(!u||!u.id)return;const p=r.get(u.id);if(p)try{p(u)}finally{r.delete(u.id)}}),q(e,r,[],t)}function L(e){if(e)throw new Error("Proxy has been released and is not useable")}function oe(e){return G(e,new Map,{type:"RELEASE"}).then(()=>{se(e)})}const V=new WeakMap,W="FinalizationRegistry"in globalThis&&new FinalizationRegistry(e=>{const t=(V.get(e)||0)-1;V.set(e,t),t===0&&oe(e)});function Ie(e,t){const r=(V.get(t)||0)+1;V.set(t,r),W&&W.register(e,t,e)}function Ce(e){W&&W.unregister(e)}function q(e,t,r=[],m=function(){}){let s=!1;const u=new Proxy(m,{get(p,o){if(L(s),o===xe)return()=>{Ce(u),oe(e),t.clear(),s=!0};if(o==="then"){if(r.length===0)return{then:()=>u};const d=G(e,t,{type:"GET",path:r.map(i=>i.toString())}).then(M);return d.then.bind(d)}return q(e,t,[...r,o])},set(p,o,d){L(s);const[i,f]=H(d);return G(e,t,{type:"SET",path:[...r,o].map(a=>a.toString()),value:i},f).then(M)},apply(p,o,d){L(s);const i=r[r.length-1];if(i===Pe)return G(e,t,{type:"ENDPOINT"}).then(M);if(i==="bind")return q(e,t,r.slice(0,-1));const[f,a]=ee(d);return G(e,t,{type:"APPLY",path:r.map(n=>n.toString()),argumentList:f},a).then(M)},construct(p,o){L(s);const[d,i]=ee(o);return G(e,t,{type:"CONSTRUCT",path:r.map(f=>f.toString()),argumentList:d},i).then(M)}});return Ie(u,e),u}function Fe(e){return Array.prototype.concat.apply([],e)}function ee(e){const t=e.map(H);return[t.map(r=>r[0]),Fe(t.map(r=>r[1]))]}const ue=new WeakMap;function ve(e,t){return ue.set(e,t),e}function Ae(e){return Object.assign(e,{[ne]:!0})}function H(e){for(const[t,r]of ie)if(r.canHandle(e)){const[m,s]=r.serialize(e);return[{type:"HANDLER",name:t,value:m},s]}return[{type:"RAW",value:e},ue.get(e)||[]]}function M(e){switch(e.type){case"HANDLER":return ie.get(e.name).deserialize(e.value);case"RAW":return e.value}}function G(e,t,r,m){return new Promise(s=>{const u=Math.trunc(Math.random()*Number.MAX_SAFE_INTEGER).toString();t.set(u,s),e.start&&e.start(),e.postMessage(Object.assign({id:u},r),m)})}function te(e,t,r,m,s,u){const p=t*r,o=p,d=p+p/4,i=u.byteLength/16,f=new ArrayBuffer(u.byteLength),a=new DataView(f),n=new DataView(u.buffer);for(let l=0;l<i;l++){const c=l%m,I=Math.floor(l/m),S=Math.round(c*(t/m)),w=Math.round(I*(r/s));if(S>=t||w>=r)continue;const v=w*t+S,P=Math.floor(w/2)*(t/2)+Math.floor(S/2),h=e[v]??0,y=(e[o+P]??128)-128,g=(e[d+P]??128)-128;let _=h+1.402*g,B=h-.344136*y-.714136*g,C=h+1.772*y;_=Math.min(255,Math.max(0,_)),B=Math.min(255,Math.max(0,B)),C=Math.min(255,Math.max(0,C));const x=l*16;a.setFloat32(x,n.getFloat32(x,!0),!0),a.setFloat32(x+4,n.getFloat32(x+4,!0),!0),a.setFloat32(x+8,n.getFloat32(x+8,!0),!0),a.setUint8(x+12,_),a.setUint8(x+13,B),a.setUint8(x+14,C),a.setUint8(x+15,255)}return new Uint8Array(f)}function re(e,t,r,m,s,u){const p=t*r,o=new Float32Array(p*3);for(let a=0;a<r;a++)for(let n=0;n<t;n++){const l=a*t+n,c=e[l]??0;let I=0,S=0,w=0;const P=c*1;if(P>0&&m!==0&&s!==0){const y=t*.5,g=r*.5;I=(n-y)*P/m,S=(a-g)*P/s,w=P,w>u&&(I=0,S=0,w=0)}const h=l*3;o[h]=I,o[h+1]=S,o[h+2]=w}const d=new ArrayBuffer(p*16),i=new DataView(d),f=new Uint8Array(o.buffer);for(let a=0;a<p;a++){const n=a*12,l=a*16;for(let c=0;c<12;++c)i.setUint8(l+c,f[n+c]);i.setUint8(l+12,0),i.setUint8(l+13,0),i.setUint8(l+14,0),i.setUint8(l+15,255)}return new Uint8Array(d)}const fe=128,Oe=16,Me=`
struct Intrinsics {
  fx: f32,
  fy: f32,
  cx: f32,
  cy: f32,
  depthScale: f32,
  depthWidth: f32,
  depthHeight: f32,
  i420Width: f32,
  i420Height: f32,
  numFrames_f: f32,
  bytesPerI420Frame_f: f32,
  maxSteroDepth: f32,
};

struct OutputPointData {
  x: f32,
  y: f32,
  z: f32,
  color: u32,
};

@group(0) @binding(0) var<storage, read> depthBuffer: array<u32>;
@group(0) @binding(1) var<storage, read> intrinsics: Intrinsics;
@group(0) @binding(2) var<storage, read_write> xyzColorBuffer: array<OutputPointData>;
@group(0) @binding(3) var<storage, read> i420Buffer: array<u32>;

fn getI420Byte(byteIndexWithinFrame: u32, frameOffsetElements: u32, bufferLengthElements: u32) -> u32 {
  let globalByteIndex = (frameOffsetElements * 4u) + byteIndexWithinFrame;
  let elementIndex = globalByteIndex / 4u;
  let offsetInElement = globalByteIndex % 4u;
  if (elementIndex >= bufferLengthElements) {
    return 0u;
  }
  let packedValue = i420Buffer[elementIndex];
  return (packedValue >> (offsetInElement * 8u)) & 0xFFu;
}

@compute @workgroup_size(${fe}, 1, 1)
fn main(@builtin(global_invocation_id) global_id: vec3<u32>) {
  let pixel_idx_in_frame = global_id.x;
  let frame_idx = global_id.y;
  let depthWidth = u32(intrinsics.depthWidth);
  let depthHeight = u32(intrinsics.depthHeight);
  let i420WidthU = u32(intrinsics.i420Width);
  let i420HeightU = u32(intrinsics.i420Height);
  let numFrames = u32(intrinsics.numFrames_f);
  let bytesPerI420Frame = u32(intrinsics.bytesPerI420Frame_f);
  let numPixelsPerFrame = depthWidth * depthHeight;
  if (pixel_idx_in_frame >= numPixelsPerFrame || frame_idx >= numFrames || depthWidth == 0u || depthHeight == 0u) {
    return;
  }
  let global_output_idx = (frame_idx * numPixelsPerFrame) + pixel_idx_in_frame;
  let depth_elements_per_frame = (numPixelsPerFrame + 1u) / 2u;
  let depth_frame_offset = frame_idx * depth_elements_per_frame;
  let i420AlignedStrideBytes = (bytesPerI420Frame + 3u) / 4u * 4u;
  let i420_elements_per_frame_aligned = i420AlignedStrideBytes / 4u;
  let i420_frame_offset = frame_idx * i420_elements_per_frame_aligned;
  let depthIndex32_within_frame = pixel_idx_in_frame / 2u;
  let packedDepthU32_idx = depth_frame_offset + depthIndex32_within_frame;
  if (packedDepthU32_idx >= arrayLength(&depthBuffer)) {
    return;
  }
  let packedDepthU32 = depthBuffer[packedDepthU32_idx];
  var rawDepthU16: u32;
  if (pixel_idx_in_frame % 2u == 0u) {
    rawDepthU16 = packedDepthU32 & 0xFFFFu;
  } else {
    rawDepthU16 = (packedDepthU32 >> 16u) & 0xFFFFu;
  }
  let u = f32(pixel_idx_in_frame % depthWidth);
  let v = f32(pixel_idx_in_frame / depthWidth);
  var outputPoint: OutputPointData;
  outputPoint.x = 0.0;
  outputPoint.y = 0.0;
  outputPoint.z = 0.0;
  outputPoint.color = 0xFF000000u;
  let fx = intrinsics.fx;
  let fy = intrinsics.fy;
  let depthScale = intrinsics.depthScale;
  let maxSteroDepth = intrinsics.maxSteroDepth;
  if (rawDepthU16 > 0u && fx != 0.0 && fy != 0.0 && depthScale > 0.0) {
    let z = f32(rawDepthU16) * depthScale;
    let imageCenterX = f32(depthWidth) * 0.5;
    let imageCenterY = f32(depthHeight) * 0.5;
    let x = (u - imageCenterX) * z / fx;
    let y = (v - imageCenterY) * z / fy;
    
    // Filter out points beyond maxSteroDepth
    if (z <= maxSteroDepth) {
      outputPoint.x = x;
      outputPoint.y = y;
      outputPoint.z = z;
      
      if (i420WidthU > 0u && i420HeightU > 0u && bytesPerI420Frame > 0u) {
        let i420X = min(i420WidthU - 1u, u32(floor(u * (intrinsics.i420Width / intrinsics.depthWidth))));
        let i420Y = min(i420HeightU - 1u, u32(floor(v * (intrinsics.i420Height / intrinsics.depthHeight))));
        let frameSizeY = i420WidthU * i420HeightU;
        let uvWidth = (i420WidthU + 1u) / 2u;
        let uvHeight = (i420HeightU + 1u) / 2u;
        let frameSizeUV = uvWidth * uvHeight;
        let uOffsetBytes = frameSizeY;
        let vOffsetBytes = frameSizeY + frameSizeUV;
        let yIndexBytes = i420Y * i420WidthU + i420X;
        let uvX = i420X / 2u;
        let uvY = i420Y / 2u;
        let uvIndexBytes = uvY * uvWidth + uvX;
        let uIndexBytes = uOffsetBytes + uvIndexBytes;
        let vIndexBytes = vOffsetBytes + uvIndexBytes;
        let i420BufferTotalElements = arrayLength(&i420Buffer);
        if (yIndexBytes < bytesPerI420Frame && uIndexBytes < bytesPerI420Frame && vIndexBytes < bytesPerI420Frame && (i420_frame_offset + (vIndexBytes / 4u)) < i420BufferTotalElements) {
          let y_byte = getI420Byte(yIndexBytes, i420_frame_offset, i420BufferTotalElements);
          let u_byte = getI420Byte(uIndexBytes, i420_frame_offset, i420BufferTotalElements);
          let v_byte = getI420Byte(vIndexBytes, i420_frame_offset, i420BufferTotalElements);
          let y_f = f32(y_byte);
          let u_f = f32(u_byte) - 128.0;
          let v_f = f32(v_byte) - 128.0;
          var r_f = y_f + 1.402 * v_f;
          var g_f = y_f - 0.344136 * u_f - 0.714136 * v_f;
          var b_f = y_f + 1.772 * u_f;
          let r = u32(clamp(r_f, 0.0, 255.0)) & 0xFFu;
          let g = u32(clamp(g_f, 0.0, 255.0)) & 0xFFu;
          let b = u32(clamp(b_f, 0.0, 255.0)) & 0xFFu;
          let a = 255u;
          outputPoint.color = (r) | (g << 8u) | (b << 16u) | (a << 24u);
        }
      }
    }
  }
  if (global_output_idx < arrayLength(&xyzColorBuffer)) {
    xyzColorBuffer[global_output_idx] = outputPoint;
  }
}
`;async function ze(e,t,r,m,s,u,p,o,d,i,f,{hasGPU:a}){const n=e.length;if(n===0||n!==o.length)return console.warn("GPU: Input frame arrays are empty or mismatched."),[];if(t<=0||r<=0)throw new Error("GPU: Invalid depth dimensions!");if(e[0]&&!(e[0]instanceof Uint16Array))throw new Error("GPU: depthFrames[0].data is NOT a Uint16Array!");if(o[0]&&!(o[0]instanceof Uint8Array))throw new Error("GPU: i420Frames[0].data is NOT a Uint8Array!");const l=1;if(!a){const h=[];for(let y=0;y<n;y++){const g=e[y],_=o[y];if(!g||!_){console.warn(`CPU Fallback: Skipping frame ${y} due to missing data.`),h.push(new Uint8Array(0));continue}try{const B=re(g,t,r,m,s,f);h.push(te(_,d,i,t,r,B))}catch(B){console.error(`CPU Fallback: Error processing frame ${y}:`,B),h.push(new Uint8Array(0))}}return h}let c=null,I=null,S=null,w=null,v=null,P=null;try{const h=await navigator.gpu.requestAdapter();if(!h)throw new Error("Failed to get GPU adapter.");c=await h.requestDevice();const y=c.queue,g=t*r,_=g*Oe,B=_*n,C=g*2,x=Math.ceil(C/4),le=x*n*4,k=o[0]?.byteLength??0;if(k===0&&n>0)throw new Error("GPU: I420 frame data is empty or invalid for size calculation.");const T=Math.ceil(k/4)*4,ce=T*n,D=new Float32Array([m,s,u,p,l,t,r,d,i,n,k,f]),de=Math.max(D.byteLength,64);S=c.createBuffer({label:"Intrinsics Buffer",size:de,usage:GPUBufferUsage.STORAGE|GPUBufferUsage.COPY_DST}),y.writeBuffer(S,0,D.buffer,D.byteOffset,D.byteLength),I=c.createBuffer({label:"Depth Buffer (Combined)",size:le,usage:GPUBufferUsage.STORAGE|GPUBufferUsage.COPY_DST,mappedAtCreation:!0});const me=I.getMappedRange(),z=new Uint32Array(me);for(let b=0;b<n;++b){const U=e[b];if(!U||!(U instanceof Uint16Array)){console.warn(`GPU: Skipping depth frame ${b} due to missing/invalid data.`);const E=b*x,A=x;z.fill(0,E,E+A);continue}const F=b*x;for(let E=0;E<g;E++){const A=U[E]??0,O=F+Math.floor(E/2);if(O>=z.length)continue;E%2===0?z[O]=z[O]&4294901760|A:z[O]=z[O]&65535|A<<16}}I.unmap(),w=c.createBuffer({label:"I420 Buffer (Combined, Aligned)",size:ce,usage:GPUBufferUsage.STORAGE|GPUBufferUsage.COPY_DST,mappedAtCreation:!0});const Z=w.getMappedRange(),K=new Uint8Array(Z);for(let b=0;b<n;++b){const U=o[b],F=b*T;if(!U||!(U instanceof Uint8Array)||U.byteLength!==k){console.warn(`GPU: Skipping I420 frame ${b} due to missing/invalid data or size mismatch.`),K.fill(0,F,F+T);continue}if(new Uint8Array(Z,F,U.byteLength).set(U),T>U.byteLength){const A=F+U.byteLength,O=T-U.byteLength;K.fill(0,A,A+O)}}w.unmap(),v=c.createBuffer({label:"Output XYZColor Buffer (Combined)",size:B,usage:GPUBufferUsage.STORAGE|GPUBufferUsage.COPY_SRC}),P=c.createBuffer({label:"Readback Buffer",size:B,usage:GPUBufferUsage.COPY_DST|GPUBufferUsage.MAP_READ});const J=c.createBindGroupLayout({label:"Compute Bind Group Layout",entries:[{binding:0,visibility:GPUShaderStage.COMPUTE,buffer:{type:"read-only-storage"}},{binding:1,visibility:GPUShaderStage.COMPUTE,buffer:{type:"read-only-storage"}},{binding:2,visibility:GPUShaderStage.COMPUTE,buffer:{type:"storage"}},{binding:3,visibility:GPUShaderStage.COMPUTE,buffer:{type:"read-only-storage"}}]}),pe=c.createBindGroup({label:"Compute Bind Group",layout:J,entries:[{binding:0,resource:{buffer:I}},{binding:1,resource:{buffer:S}},{binding:2,resource:{buffer:v}},{binding:3,resource:{buffer:w}}]}),ye=c.createShaderModule({label:"Compute Shader Module",code:Me}),ge=c.createComputePipeline({label:"Compute Pipeline",layout:c.createPipelineLayout({bindGroupLayouts:[J]}),compute:{module:ye,entryPoint:"main"}}),X=c.createCommandEncoder({label:"Compute Command Encoder"}),R=X.beginComputePass({label:"Compute Pass"});R.setPipeline(ge),R.setBindGroup(0,pe);const he=Math.ceil(g/fe),be=n;R.dispatchWorkgroups(he,be,1),R.end(),X.copyBufferToBuffer(v,0,P,0,B),y.submit([X.finish()]),await P.mapAsync(GPUMapMode.READ);const _e=P.getMappedRange(),Q=new Uint8Array(_e.slice(0));P.unmap(),P=null;const N=[];for(let b=0;b<n;b++){const U=b*_,F=Math.min(U+_,Q.byteLength),E=Q.slice(U,F);E.byteLength!==_?(console.warn(`GPU: Result frame ${b} has incorrect size (${E.byteLength} vs ${_}). Padding or error occurred.`),N.push(new Uint8Array(_))):N.push(E)}return N}catch(h){console.error("GPU: Error during WebGPU processing:",h),console.warn("GPU: Falling back to CPU due to error.");const y=[];for(let g=0;g<n;g++){const _=e[g],B=o[g];if(!_||!B){console.warn(`CPU Fallback (error path): Skipping frame ${g} due to missing data.`),y.push(new Uint8Array(0));continue}try{const C=re(_,t,r,m,s,f);y.push(te(B,d,i,t,r,C))}catch(C){console.error(`CPU Fallback (error path): Error processing frame ${g}:`,C),y.push(new Uint8Array(0))}}return y}finally{I?.destroy(),S?.destroy(),w?.destroy(),v?.destroy(),P?.destroy()}}j({depthToPointcloudGPU:ze});
//# sourceMappingURL=pointcloudFromDepth.worker-BuoR8w9Z-C7ZAnA_N.js.map
